/// @function DrawTextWithOutline(x, y, string, [text_color], [outline_color]);
/// @description Draws text with outline
/// @param {real} X position of the text
/// @param {real} Y position of the text
/// @param {string} String to draw
/// @param {color} The text color (default is white)
/// @param {color} The outline color (default is black)

var xxx = argument[0];
var yyy = argument[1];
var text = argument[2];
var text_color = c_white;
if argument_count > 3 then text_color = argument[3];
var outline_color = c_black;
if argument_count > 4 then outline_color = argument[4];

// Store the original color
var original_color = draw_get_color();

// Draw the outline
if (draw_get_color()!= outline_color)
	draw_set_color(outline_color);
draw_text(xxx+1, yyy+1, text);
draw_text(xxx-1, yyy-1, text);
draw_text(xxx  , yyy+1, text);
draw_text(xxx+1, yyy  , text);
draw_text(xxx  , yyy-1, text);
draw_text(xxx-1, yyy  , text);
draw_text(xxx-1, yyy+1, text);
draw_text(xxx+1, yyy-1, text);

// Draw the colored text
draw_set_color(text_color);
draw_text(xxx, yyy, text);

// Restore the original color if need be
if (original_color != text_color)
	draw_set_color(original_color);
